implementation module osPrint08

import StdEnv,intrface,clCrossCall
import deltaPicture, picture, ioTypes, Events

::	PrintSetup
	=	{	devmode	::	!String
		,	device	::	!String
		,	driver	::	!String
		,	output	::	!String
		}
::	JobInfo
	=	{	range	::	!(!Int,!Int)
		,	copies	::	!Int
		}
::	PrintInfo
	=	{	printSetup			::	PrintSetup
		,	jobInfo				::	JobInfo
		}
::	Alternative x y
	=	Cancelled x
	|	StartedPrinting y
::	*PState *s
	=	{	s	:: s
		,	io	:: IOState s
		}


os_getpagedimensions	::	!PrintSetup	!Bool 
						->	!(!(!Int,!Int),
							  !(!(!Int,!Int),!(!Int,!Int)),
							  !(!Int,!Int))
os_getpagedimensions	{ devmode, device, driver } emulateScreenRes
	= os_getpagedimensionsC devmode device driver emulateScreenRes
	
os_defaultprintsetup	::	!*env
						->	(!PrintSetup, !*env)
os_defaultprintsetup env
	#	(dmSize,printerHandle,device,driver,output,env)	= getDevmodeSizeC env
	|	dmSize==0
		= ({devmode="", device="", driver="", output=""},env)
	#	devmode			= createArray dmSize ' '
		devmode			= { devmode & [dec dmSize]='\0'}
		env				= getDefaultDevmodeC devmode printerHandle device env	// alters contents of printSetup
	= ({devmode=devmode, device=device, driver=driver, output=output}, env)

os_printsetupdialog		::	!Bool !PrintSetup !*env
						->	(!PrintSetup, !*env)
os_printsetupdialog isWorld {devmode,device,driver,output} env
	# (os, env)		= EnvGetOS env
	# (devmodePtr,os) = WinMakeCString devmode os
	  (devicePtr,os) = WinMakeCString device os
	  (driverPtr,os) = WinMakeCString driver os
	  (outputPtr,os) = WinMakeCString output os
	  (ok, pdPtr, os)
	  		= CCPrintSetupDialog isWorld (size devmode) devmodePtr devicePtr driverPtr outputPtr os
	  os = WinReleaseCString devmodePtr os
	  os = WinReleaseCString devicePtr os
	  os = WinReleaseCString driverPtr os
	  os = WinReleaseCString outputPtr os
	| ok==0
		= ({devmode="",device="",driver="",output=""}, EnvSetOS os env)
	# (ndevmode,ndevice,ndriver,noutput,os)	= get_printSetup_with_PRINTDLG pdPtr os
	= ({devmode=ndevmode,device=ndevice,driver=ndriver,output=noutput}, EnvSetOS os env)

os_printsetupvalid		::	!PrintSetup !*env
						->	(!Bool, !*env)
os_printsetupvalid {devmode,device,driver} env
	= os_printsetupvalidC devmode device driver env

os_printsetupvalidC	::	!String !String !String!*env -> (!Bool, !*env)
os_printsetupvalidC _ _ _ _
	= code
		{
			ccall os_printsetupvalidC "SSS:I:A"
		}

class PrintEnvironments printEnv
  where
	os_printpageperpage ::	!.Bool !Bool 
							!.x
							.(.x -> .(PrintInfo -> .(*Picture -> ((.Bool,Point),(.state,*Picture)))))
							((.state,*Picture) -> ((.Bool,Point),(.state,*Picture)))
							!PrintSetup !*printEnv
						-> 	(Alternative .x .state,!*printEnv)

instance PrintEnvironments (PState s)
where
	os_printpageperpage doDialog emulateScreen x initFun transFun printSetup {s,io}
		# (ioa, os) = UnpackIOState io
		# (x, mb_sioa, os) = printPagePerPageBothSemaphor
								doDialog emulateScreen x initFun transFun printSetup (Just (s,ioa)) os
		  (s,ioa) = fromJust mb_sioa
		= (x, {s=s, io=PackIOState ioa os})
		
instance PrintEnvironments Files
where
	os_printpageperpage doDialog emulateScreen x initFun transFun printSetup files
		# (os, files) = EnvGetOS files
		  (x,_,os) = printPagePerPageBothSemaphor
		  					doDialog emulateScreen x initFun transFun printSetup Nothing os
		= (x, EnvSetOS os files) 
		
printPagePerPageBothSemaphor p1 p2 x p4 p5 printSetup mb_sioa os
// with this mechanism it is assured, that only one print job can happen at a time.
// addSemaphor adds the parameter to a C global and gives back the previous value of that
// global
	# (s,os) = addSemaphor 1 os
	| s>0 
		# (_,os) = addSemaphor (-1) os
		= (Cancelled x,mb_sioa,os)
	# (result,mb_sioa,os) = printPagePerPageBoth p1 p2 x p4 p5 printSetup mb_sioa os
	  (_,os) = addSemaphor (-1) os
	= (result,mb_sioa,os)

printPagePerPageBoth doDialog emulateScreen x initFun transFun printSetup mb_sioa os
	  // do the print dialog (or not) and get the hdc and the printInfo
	  
	  # (err, hdc, printInfo, mb_sioa, os)
	  		= getPrintInfo doDialog emulateScreen printSetup mb_sioa os

	  // check, whether the user canceled

	  | err >= 0 = (Cancelled x, mb_sioa, os)

	  // call StartDoc either via the OS thread or direct

	  #	(err, mb_sioa, os) = CCstartDoc hdc mb_sioa os
  
	  | err <= 0 = (Cancelled x, mb_sioa, deleteDC hdc os)
			// user cancelled printing to file from file dialog

	  // initialise printer picture and call the initFun function

	  # picture = initPicture zeroOrigin (hdc,os)
	    (endOrig,(initState,picture)) = initFun x printInfo picture
	    (hdc,os) = UnpackPicture picture
		(_, _, _, _, _, _, (hdc,os))
	                = WinDonePicture (hdc,os)

	  // now print all pages
  
	    (finalState,hdc,mb_sioa,os)
	  		= printPages 0 transFun endOrig initState hdc mb_sioa os

	  // Sluit af

	    (mb_sioa, os) = CCendDoc hdc mb_sioa os
	  = (StartedPrinting finalState, mb_sioa, (deleteDC hdc os))


printPages _ _ (True,_) state hdc mb_sioa os
  =(state,hdc,mb_sioa,os)
printPages pageNr fun (_,origin) state hdc mb_sioa os

  // give OS thread eventually a chance to handle events
  # (mb_sioa,os) = evtlSwitchToOS pageNr hdc mb_sioa os
  
  #	(ok, os)	= startPage hdc os
  | ok == 0 = abort "\nosPrint08: Failed in \"StartPage\". Probably not enough memory."
  #	picture = initPicture origin (hdc,os)
  // apply drawfunctions contained in this page
	((endOfDoc,nextOrigin),(state`,picture))	= fun (state,picture)
  // finish drawing
  # (hdc,os)			= UnpackPicture picture
	(_, _, _, _, _, _, (hdc,os))
	                = WinDonePicture (hdc,os)
	(ok, os)	= endPage hdc os
    // ok value False should not cause an abort, because endPage returns an error, when user chooses
  	// "encapsulated postscript" as output format and the output is longer than one page.
  	(canceled,os)	= wasCanceled os
	// draw rest of pages
  =	printPages (inc pageNr) fun (endOfDoc || canceled || (ok==0),nextOrigin)  state` hdc mb_sioa os
      
zeroOrigin :== (0,0)   		

///////////////////////////////////////////////////////////////////////////////

getPrintInfo doDialog emulateScreen {devmode, device, driver, output} mb_sioa os
	# (devmodePtr,os) = WinMakeCString devmode os
	  (devicePtr,os) = WinMakeCString device os
	  (driverPtr,os) = WinMakeCString driver os
	  (outputPtr,os) = WinMakeCString output os
	  ( err, data, pdPtr, mb_sioa, os)
	  		= CCgetDC	(if doDialog 1 0) (if emulateScreen 2 0)	// these two bits will be packed into one word in CCgetDC
						(size devmode) devmodePtr devicePtr driverPtr outputPtr mb_sioa os
	  os = WinReleaseCString devmodePtr os
	  os = WinReleaseCString devicePtr os
	  os = WinReleaseCString driverPtr os
	  os = WinReleaseCString outputPtr os
	| doDialog && (err==(-1))
		= continuation err data mb_sioa (get_printSetup_with_PRINTDLG pdPtr os)
	= continuation err data mb_sioa (devmode,device,driver,output,os)
  where
	continuation err (first,last,copies,hdc) mb_sioa (devmode,device,driver,output,os)
		# first` = max 1 first
		  last` = max first` last
		  copies` = max 1 copies
		= ( err,
		     hdc,
		     {printSetup	= { devmode=devmode, device=device ,driver=driver, output=output },
   			  	jobInfo		= {	range = (first`,last`),
   	    						copies = copies`
   	    					  }
 		     },
		     mb_sioa,
 		   	 os
   		   )

CCgetDC doDialog emulateScreen devmodeSize devmodePtr devicePtr driverPtr outputPtr Nothing os
	# (ok,first,last,copies,pdPtr,deviceContext,os)
		= getDC doDialog emulateScreen 1 devmodeSize devmodePtr devicePtr driverPtr outputPtr os
	= (ok,(first,last,copies,deviceContext),pdPtr,Nothing,os)
CCgetDC doDialog emulateScreen devmodeSize devmodePtr devicePtr driverPtr outputPtr (Just (s,ioa)) os
	# createcci = (CcRqGET_PRINTER_DC, doDialog bitor emulateScreen,devmodeSize,devmodePtr,devicePtr,driverPtr,outputPtr)
	  (rcci,(s,ioa), os)  = IssueCleanRequest StdCallback createcci (s,ioa) os
	  (_,err,first,last,copies,pdPtr,deviceContext) = rcci
	= (	err,(first,last,copies,deviceContext),pdPtr,
		Just (s,ioa),os
	  )

CCPrintSetupDialog True devmodeSize devmodePtr devicePtr driverPtr outputPtr os
	= printSetup 1 devmodeSize devmodePtr devicePtr driverPtr outputPtr os
CCPrintSetupDialog False devmodeSize devmodePtr devicePtr driverPtr outputPtr os
	# createcci = (CcRqDO_PRINT_SETUP,devmodeSize,devmodePtr,devicePtr,driverPtr,outputPtr,0)
	  (rcci, _, os)  = IssueCleanRequest (ErrorCallback "ERROR in osPrint08") createcci 0 os
	  (_,ok,pdPtr,_,_,_,_) = rcci
	= (ok, pdPtr, os)

// error code: -1:no error, 0: user canceled file dialog, others: other error
CCstartDoc hdc Nothing os
	# (err,os) = startDoc hdc os
	= (err,Nothing,os)
CCstartDoc hdc (Just (s,ioa)) os
	# createcci = (CcRqSTARTDOC, hdc, 0,0,0,0,0 )
	  (rcci,(s,ioa), os)  = IssueCleanRequest StdCallback createcci (s,ioa) os
	  (_,err,_,_,_,_,_) = rcci
	= (err,Just (s,ioa), os)

CCendDoc hdc Nothing os
	# os = endDoc hdc os
	= (Nothing,os)
CCendDoc hdc (Just (s,ioa)) os
	# createcci = (CcRqENDDOC, hdc, 0,0,0,0,0 )
	  (_,(s,ioa), os)  = IssueCleanRequest StdCallback createcci (s,ioa) os
	= (Just (s,ioa),os)

evtlSwitchToOS _ _ Nothing os
	= (Nothing,os)
evtlSwitchToOS pageNr hdc (Just (s,ioa)) os
	# nrStr = toString pageNr
	# messageText = if (pageNr==0)	""
									(nrStr+++" page"+++(if (pageNr==1) "" "s")+++" printed")
	# (textPtr,os) = WinMakeCString messageText os
	# createcci = (CcRqDISPATCH_MESSAGES_WHILE_PRINTING, textPtr,0,0,0,0,0 )
	# (_,(s,ioa), os)  = IssueCleanRequest StdCallback  createcci (s,ioa) os
	# os = WinReleaseCString textPtr os
	= (Just (s,ioa), os) 

initPicture origin intPict
  #	picstate = InitialPictureState
    intPict = WinInitPicture 
      picstate.ppensize
      picstate.ppenmode
      picstate.ppencolor
      picstate.pbackcolor
      picstate.ppoint
      picstate.pfont
      origin
      intPict
 = PackPicture (fst intPict) (snd intPict)
	
clpPP :: !Rectangle !*Picture -> *Picture
clpPP rect picture
	# intPict = UnpackPicture picture
	  (hdc,os) = WinClipPictureMW (RectangleToRect rect) intPict
	= PackPicture hdc os

EnvGetOS :: !*env -> (!*OS,!*env)
EnvGetOS env
  = (42,env)

EnvSetOS :: !*OS !*env -> *env
EnvSetOS os env
  = env


::	Maybe x
	=	Just x
	|	Nothing

fromJust :: !(Maybe .x) -> .x
fromJust (Just x) = x

//////////////////////////////////////////////////
//												//
//				C CALLING FUNCTIONS				//	
//												//
//////////////////////////////////////////////////

:: OkReturn :== Int		// okReturn<>0 <=> ok !

os_getpagedimensionsC	::	!String !String !String !Bool 
						->	(!(!Int,!Int), !(!(!Int,!Int),!(!Int,!Int)), !(!Int,!Int))
os_getpagedimensionsC _ _ _ _
	= code
		{
			ccall	os_getpagedimensionsC "SSSI-IIIIIIII"
		}
		
getDevmodeSizeC	::	!*env	-> (!Int,!Int,!String,!String,!String,!*env)
getDevmodeSizeC _
	= code
		{
			ccall getDevmodeSizeC ":VIISSS:A"
		}
		
getDefaultDevmodeC	::	!{#Char} !Int !String !*env	->	*env
getDefaultDevmodeC _ _ _ _
	= code
		{
			ccall getDefaultDevmodeC "SIS:V:A"
		}
		
editprintsetupC	::	!String !String !String !String !*env	->	(!String, !String, !String, !String, !*env)
editprintsetupC _ _ _ _ _
	= code
	{
		ccall editprintsetupC "SSSS:VSSSS:A"
	}

printSetup	:: !Int !Int !Int !Int !Int !Int !*OS -> (!OkReturn,!Int,!*OS)
printSetup _ _ _ _ _ _ _
	= code
		{
			ccall printSetup "IIIIII:VII:I"
		}

get_printSetup_with_PRINTDLG	::	!Int !*OS -> (!String, !String, !String, !String, !*OS)
get_printSetup_with_PRINTDLG _ _
	= code
		{
			ccall get_printSetup_with_PRINTDLG "I:VSSSS:I"
		}

startPage :: !HDC !*OS -> (!OkReturn, !*OS)
startPage _ _
	= code
	{
			ccall startPage "I:I:I"
	}

endPage ::	!HDC !*OS -> (!OkReturn, !*OS)
endPage _ _
	= code
	{
			ccall endPage "I:I:I"
	}

startDoc :: !HDC !*OS -> (!Int, !*OS)
			// err code: >0:no error, <=0: user cancelled file dialog
startDoc _ _
	= code
	{
			ccall startDoc "I:I:I"
	}

endDoc :: !HDC !*OS -> *OS
endDoc _ _
	= code
	{
			ccall endDoc "I:V:I"
	}

wasCanceled :: !*OS -> (!Bool,!*OS)
wasCanceled _
	= code
	{
			ccall wasCanceled ":I:I"
	}

deleteDC :: !HDC !*OS -> *OS
deleteDC _ _
	= code
	{
			ccall deleteDC "I:V:I"
	}


getDC :: !Int !Int !Int !Int !Int !Int !Int !Int !*OS -> (!Int, !Int, !Int, !Int, !Int, !Int, !*OS)
// getDC doDialog emulateScreen "getDC called directly from CleanThread" devmodeSize
// first element of result is an error code:
// -1:no error, others: non fatal error
getDC _ _ _ _ _ _ _ _ _
	= code
	{
			ccall getDC "IIIIIIII:VIIIIII:I"
	}

addSemaphor :: !Int !*OS  -> (!Int,!*OS)
addSemaphor _ _
	= code
	{
			ccall addSemaphor "I:I:I"
	}

os_printsetuptostring	::	!PrintSetup -> String
os_printsetuptostring {devmode, device, driver, output}
	=		toString (size devmode)+++" "+++toString (size device)+++" "+++toString (size driver)+++" "
		 +++devmode+++device+++driver+++output

os_stringtoprintsetup	::	!String -> PrintSetup
os_stringtoprintsetup string
	#!	chList	= [ch \\ ch<-:string]
		(sizeChLists, rest)	= seqList (repeatn 3 (splitInt [])) chList
		sizes	= map (toInt o toString) sizeChLists
		(devmodeSize, deviceSize, driverSize)	= listTo3Tuple sizes
		devmode	= toString (rest % (0, devmodeSize-1))
		driverStartIndex = devmodeSize+deviceSize
		device	= toString (rest % (devmodeSize, driverStartIndex-1))
		outputStartIndex	= driverStartIndex+driverSize
		driver	= toString (rest % (driverStartIndex, outputStartIndex-1))
		output	= toString (rest % (outputStartIndex, (size string)-1))
	|		size devmode==devmodeSize && size device==deviceSize
		&&	size driver==driverSize && size output==(length rest)-outputStartIndex
		&&	devmodeSize>0 && deviceSize>0 && driverSize>0 && size output>0
		= {devmode=devmode, device=device, driver=driver, output=output}
	= {devmode="\0", device="\0", driver="\0", output="\0"}
  where
	splitInt akku []
		= (reverse akku, [])
	splitInt akku [ch:chs]
		|	isDigit ch
			= splitInt [ch:akku] chs
		= (reverse akku, chs)
	listTo3Tuple [e1,e2,e3] = (e1,e2,e3)

OSprintSetupTypical	::	Bool
OSprintSetupTypical = False
